/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.timingAnalyzer;

import com.quantumdata.sam.SignalAnalysisModule;
import com.quantumdata.sam.reporting.TimingAnalysisReport.Result;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import java.text.DecimalFormat;

public class TimingAnalyzerEngine {
    public static Result retrieveDataFromInstrument(boolean bl) {
        InstrumentResponse instrumentResponse;
        RemoteInstrument remoteInstrument = SignalAnalysisModule.ri;
        Result result = new Result();
        if (bl && (instrumentResponse = remoteInstrument.sendCmd("tmau")).isError()) {
            SignalAnalysisModule.sam.println(instrumentResponse.getResponse());
            return null;
        }
        String string = bl ? "tmax:htot?" : "htot?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHtot(instrumentResponse.getResponse());
        string = bl ? "tmax:hres?" : "hres?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHres(instrumentResponse.getResponse());
        string = bl ? "tmax:hspd?" : "hspd?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHspd(instrumentResponse.getResponse());
        string = bl ? "tmax:hspw?" : "hspw?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHspw(instrumentResponse.getResponse());
        string = bl ? "tmax:hspp?" : "hspp?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHspp(instrumentResponse.getResponse());
        string = bl ? "tmax:hvpd?" : "hvpd?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHvpd(instrumentResponse.getResponse());
        string = bl ? "tmax:vtot?" : "vtot?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setVtot(instrumentResponse.getResponse());
        string = bl ? "tmax:vres?" : "vres?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setVres(instrumentResponse.getResponse());
        string = bl ? "tmax:vspd?" : "vspd?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setVspd(instrumentResponse.getResponse());
        string = bl ? "tmax:vspw?" : "vspw?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setVspw(instrumentResponse.getResponse());
        string = bl ? "tmax:vspp?" : "vspp?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setVspp(instrumentResponse.getResponse());
        string = bl ? "tmax:scan?" : "scan?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setScan(instrumentResponse.getResponse());
        string = bl ? "tmax:hrat?" : "hrat?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setHrat(instrumentResponse.getResponse());
        string = bl ? "tmax:prat?" : "prat?";
        instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        result.setPrat(new DecimalFormat("##.000").format(Double.parseDouble(instrumentResponse.getResponse())));
        return result;
    }

    public static String getCurrentFormatName() {
        return TimingAnalyzerEngine.getQueryResponse("fmtl?");
    }

    public static void restorePreviousFormat(String string) {
        SignalAnalysisModule.ri.sendCmd("fmtl " + string);
    }

    public static String getClosestFormatName() {
        return TimingAnalyzerEngine.getQueryResponse("tmax:ffmt?");
    }

    public static boolean setClosestFormat(String string) {
        RemoteInstrument remoteInstrument = SignalAnalysisModule.ri;
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("fmtl /tffs0/Library/Formats/" + string + ".xml");
        return !instrumentResponse.isError();
    }

    public static String getClosestFormatDvic() {
        return TimingAnalyzerEngine.getQueryResponse("dvic?");
    }

    private static String getQueryResponse(String string) {
        RemoteInstrument remoteInstrument = SignalAnalysisModule.ri;
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return null;
        }
        return instrumentResponse.getResponse();
    }
}

